local Convo = require "questral.convo"
local Npc = require "components.npc"
local Quest = require "questral.quest"
local Quip = require "questral.quip"
local fmodtable = require "defs.sound.fmodtable"
local quest_helper = require "questral.game.rotwoodquestutil"
local Mastery = require"defs.masteries"

local quest_strings = require("strings.strings_npc_dojo_master").QUESTS.twn_shop_dojo

local Q = Quest.CreateTownShopChat()
	:AddStrings(quest_strings)

function Q:Quest_EvaluateSpawn(quester)
	return true
end

------CAST DECLARATIONS------

Q:UpdateCast("giver")
	:FilterForPrefab("npc_dojo_master")

------OBJECTIVE DECLARATIONS------

Q:AddObjective("resident")
	:SetIsUnimportant()
	:InitialState(QUEST_OBJECTIVE_STATE.s.ACTIVE)

------CONVERSATIONS AND QUESTS------

Q:OnHub("resident", "giver", function(quest)
	--has the player had the masterys intro explained
	--jcheng: pf can get in a bad state, so check for the quest instead
	local player = quest:GetPlayer()

	local unlocked_masteries = player:IsFlagUnlocked("qc_twn_mastery_explainer") or player:IsFlagUnlocked("pf_unlocked_masteries")
	-- player has done 1 or more runs
	local is_progressed = player.components.progresstracker:GetTotalNumRuns() > 1

	return unlocked_masteries or is_progressed
end)
	:Fn(function(cx)
		cx:Opt("OPT_OPEN_MASTERY")
			:MakeArmor()
			:Fn(function()
				quest_helper.OpenShop(cx, require("screens.town.masteryscreen"))
				cx:End()
			end)
	end)

return Q
